-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" )

HeaderFont = {
  standardFont,
  28,
  AquaColor
};

TableInfoFont = {
  standardFont,
  10,
 AquaColor
};

ErrorFont = {
  standardFont,
  24,
 AquaColor
};

AccountFont = {
  standardFont,
  16,
  DeepAquaColor
};

ScoreFont = {
  standardFont,
  14,
  AquaColor
};

HiscoreSubmitLegal = {
  standardFont,
  14,
  AquaColor
};

NameFontOrange = {
	standardFont,
	15,
	TittleAqua
};

kPlayerNameY = 90;
kScoreY = 130;
kYourPFAccountY = 160;
kAccountNameY = 190;
kPasswordY = 220;
kRememberY = 230;

kPrivacyLabel = 'privacy';
if (IsEnabled(kHiscoreAnonymous)) then
	kPrivacyLabel = 'privacy_info';
end


kTitleMedalLAbel = 'submitmedalglobal';
if NumEarnedMedals() > 1 then
	kTitleMedalLAbel = 'submitmedalglobal.more';
end


function SwitchModes( submit )
	
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	if submit then
		DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
	else
		DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
	end

	EnableWindow("header",not submit);
	EnableWindow("headershadow",not submit);
	EnableWindow("playertext", not submit);
	EnableWindow("eligiblescore", not submit);
	EnableWindow("yourpfaccount", not submit and fullHS);
	EnableWindow("nametext", not submit and fullHS);
	EnableWindow("passtext", not submit and fullHS);

	EnableWindow("nameeditbox", not submit );
	EnableWindow("accounteditbox", not submit and fullHS);
	EnableWindow("passeditbox", not submit and fullHS);
	EnableWindow("remember", not submit and fullHS);

	EnableWindow("submittoserver", not submit);
	EnableWindow("submitcancel", not submit);
	EnableWindow("submitconnect", submit);

end

MakeDialog
{
	name="medalsubmitscreen",

	Bitmap
	{ 
		image="images/ui/common/popup02",	
		x=kCenter,
		y=kCenter,

		MedalSubmit
		{
			x=0,y=0,h=kMax,w=kMax,
			SetStyle(DefaultStyle);
			
			Text
			{
				font = HeaderFont,
				name = "header",
				x=0,y=40,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = kTitleMedalLAbel
			};
			
			
--			Text
--			{
--				font = AccountFont,
--				name = "playertext",
--				x=0,y=kPlayerNameY,w=145,h=kMax,
--				flags = kHAlignRight + kVAlignTop,
--				label = "playerlabel"
--			};
			
			Text
			{
				font = NormalHelpFont,
				name = "yourpfaccount",
				x=90,y=kYourPFAccountY,w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "yourpfaccount"
			};
			
			Text
			{
				font = AccountFont,
				name = "nametext",
				x=0,y=kAccountNameY,w=145,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "namelabel"
			};
			
			Text
			{
				font = AccountFont,
				name = "passtext",
				x=0,y=kPasswordY,w=145,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "passwordlabel"
			};
			
	--			Text
	--			{
	--				font = TableInfoFont,
	--				name = "submitconnect",
	--				x=kCenter,y=kCenter,w=kMax,h=kMax,
	--				flags = kHAlignCenter + kVAlignCenter,
	--				label = "connectingtoserver"
	--			};
			
			Text
			{
				font = ErrorFont,
				name = "submiterror",
				x=40,y=0,w=kMax-40,h=kMax,
				flags = kHAlignCenter + kVAlignCenter,
				label = "Error Message"
			};
			
			Text
			{
				x = 20, w = kMax-20,
				y = 400, h = kMax,
				font = HiscoreSubmitLegal;
				flags = kHAlignLeft + kVAlignTop,
				label = kPrivacyLabel
			};

		
			Bitmap
			{
				name="accounteditbox",
				image="images/ui/buttons/box03",
				x=155,
				y=kAccountNameY-5,
				
				TextEdit
				{
					flags = kHAlignCenter,
					font = NameFontOrange,
					name = "accountedit",
					label= gAccountEdit,
					x=10,y=3,w=kMax,h=kMax,
					length=15,
					ignore = kIllegalNameChars
					
				};
			};
			
			Bitmap
			{
				name="passeditbox",
				image="images/ui/buttons/box03",
				x=155,
				y=kPasswordY-5,
				
				TextEdit
				{
					flags = kHAlignCenter,
					font = PopupFontOrange,
					name = "passedit",
					label= gPassEdit,
					x=10,y=3,w=kMax,h=kMax,
					password = true,
					length=15
					
				};
			};
			
			SetStyle(CheckboxButtonStyleFitness),
			Button
			{
				x=75, y=kRememberY,

				name="remember",
				type = kToggle,
				w=260,
				h=20,
				rollover = "",
				drop = false,
				sound = "audio/sfx/checkbox.ogg",
				
				Text
				{
					font = NormalHelpFont,
					name = "rememberlabel",
					x=55,
					y=30,
					w=250,
					h=25,
					flags = kHAlignLeft + kVAlignTop,
					label="rememberpfaccount",
				};
			};
			
			SetStyle(FitnessButtonStyleTittleSmallBlue),
	--Submit
			SBButton
			{
				x=kCenter+50,
				y=kMax-100,
				name="submittoserver",
				
				icon="assets/images/ui/buttons/icon/iconok",
				default= true, -- this should be the default button (on enter)

				command = 
					function()
						name = GetLabel("nameedit");
						account = GetLabel("accountedit");
						pass = GetLabel("passedit");
						remember = GetButtonToggleState("remember");
						SubmitToServer(name,account,pass,remember);
					end
			},
			Text
			{
				font = SmallFont,
				x=kCenter+50,
				y=kMax-100+30,
				flags = kHAlignCenter + kVAlignCenter,
				label="submit",
			};
	--Cancel
			SBButton
			{
				x=kCenter -50,
				y=kMax-100,
				
				icon="assets/images/ui/buttons/icon/iconcancel",
				command = 
					function()
						PopModal("medalsubmitscreen");
					end
			};
			Text
			{
				font = SmallFont,
				x=kCenter -50,
				y=kMax-100+30,
				label = "common.cancel.label",
				flags = kHAlignCenter + kVAlignCenter,
			};
	--Submit
			SBButton
			{
				x=kCenter+50,
				y=kMax-100,
				name="submiterrorok",
				icon="assets/images/ui/buttons/icon/iconok",
				command=
					function()
						EnableWindow("submiterrorok",false);
						EnableWindow("submiterror",false);
						SwitchModes(false);
					end
			};
		}
	}
}

EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);
SetButtonToggleState('remember',gRemember);
SetFocus("nameedit");